<?php
namespace lib;

abstract class Session
{
	public static function get($key, $protect=SECRET)
	{
		if(isset($_COOKIE[$key]))
		{
			$value = self::decrypt($_COOKIE[$key], $_SERVER['REMOTE_ADDR']);
			$length = strlen($protect);
			
			if(substr($value, -$length) != $protect)
			{
				return null;
			}
			
			return substr($value, 0, strlen($value) - $length);
		}
		
		return null;
	}
	
	public static function set($key, $value, $expire=0, $protect=SECRET)
	{
		$_COOKIE[$key] = self::encrypt($value.$protect, $_SERVER['REMOTE_ADDR']);
		
		setcookie($key, $_COOKIE[$key], $expire, WEB.'/');
		
		return $value;
	}
	
	public static function delete($key)
	{
		unset($_COOKIE[$key]);
		
		setcookie($key, null, -1, WEB.'/');
	}
	
	public static function encrypt($value, $salt='')
	{
		$code = '';
		
		$length = strlen($value);
		$secret = strlen(SECRET.$salt);
		
		for($i=0; $i<$length; $i++)
		{
			$code .= chr(ord($value{$i}) + ord(substr(SECRET.$salt, $i % $secret - 1, 1)));
		}
		
		return str_replace('=', '', base64_encode($code));
	}
	
	public static function decrypt($code, $salt='')
	{
		$value = '';
		
		if($mod = strlen($code) % 4)
		{
			$code .= str_repeat('=', 4 - $mod);
		}
		
		$code = base64_decode($code);
		
		$length = strlen($code);
		$secret = strlen(SECRET.$salt);
		
		for($i=0; $i<$length; $i++)
		{
			$value .= chr(ord($code{$i}) - ord(substr(SECRET.$salt, $i % $secret - 1, 1)));
		}
		
		return $value;
	}
	
	public static function __callStatic($key, $args)
	{
		global $autoload;
		
		return $autoload['Session'][$key];
	}
}